/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilteredItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    public static final int SLOTS_PER_TYPE = 2;
    NonNullList<ItemStack> filterStacks;
    private int[] totalAmounts;
    private int[] totalLimits;
    private int[] unitWorth;
    private boolean dynamicSize = false;
    private NonNullList<ItemStack> stacks;

    protected FilteredItemStackHandler(int initialSlots) {
        this.stacks = FilteredItemStackHandler.getDefaultSizedList(initialSlots * 2);
        this.totalAmounts = new int[initialSlots];
        this.filterStacks = FilteredItemStackHandler.getDefaultSizedList(initialSlots);
    }

    public FilteredItemStackHandler(int[] totalLimits, Item[] items, int[] unitWorth) {
        this(totalLimits, FilteredItemStackHandler.getItemStacks(items), unitWorth);
    }

    public FilteredItemStackHandler(int[] totalLimits, NonNullList<ItemStack> filterStacks, int[] unitWorth) {
        this(filterStacks.size());
        this.totalLimits = totalLimits;
        this.filterStacks = filterStacks;
        this.unitWorth = unitWorth;
    }

    private static NonNullList<ItemStack> getItemStacks(Item[] items) {
        NonNullList itemStacks = NonNullList.func_191196_a();
        for (Item item : items) {
            itemStacks.add((Object)new ItemStack(item));
        }
        return itemStacks;
    }

    public int getParentSlot(int slot) {
        return slot / 2;
    }

    private boolean isInputSlot(int slot) {
        return (slot + 1) % 2 != 0;
    }

    public int getTotalAmount(int parentSlot) {
        return parentSlot < this.totalAmounts.length ? this.totalAmounts[parentSlot] : 0;
    }

    public void setTotalAmount(int parentSlot, int amount) {
        if (this.dynamicSize && amount == 0 && this.getParentSlotRemovable(parentSlot)) {
            this.removeValidItemStackFromSlot(parentSlot);
        } else {
            this.totalAmounts[parentSlot] = amount;
            this.updateInputOutputSlots(parentSlot);
        }
    }

    private void addValidItemStack(ItemStack stack) {
        this.expandStacks();
        this.filterStacks.add((Object)stack);
        this.totalAmounts = this.expandIntArray(this.totalAmounts, 0);
    }

    private int[] expandIntArray(int[] values, int newSize, int def) {
        int[] expandedArray = new int[newSize];
        System.arraycopy(values, 0, expandedArray, 0, values.length);
        return expandedArray;
    }

    private int[] expandIntArray(int[] values, int def) {
        int[] expandedArray = this.expandIntArray(values, values.length + 1, def);
        expandedArray[values.length] = def;
        return expandedArray;
    }

    private int[] removeFromIntArray(int[] values, int index) {
        int[] shrunkArray = new int[values.length - 1];
        if (index > 0) {
            System.arraycopy(values, 0, shrunkArray, 0, index);
        }
        if (index < values.length - 1) {
            System.arraycopy(values, index + 1, shrunkArray, index, values.length - (index + 1));
        }
        return shrunkArray;
    }

    private void expandStacks() {
        if (this.dynamicSize) {
            FilteredItemStackHandler.addEmptyStacks(this.stacks, 2);
        }
    }

    private void removeStack(int parentSlot) {
        if (this.dynamicSize) {
            for (int i = 0; i < 2; ++i) {
                this.stacks.remove(parentSlot * 2);
            }
        }
    }

    private void removeValidItemStackFromSlot(int parentSlot) {
        this.filterStacks.remove(parentSlot);
        this.totalAmounts = this.removeFromIntArray(this.totalAmounts, parentSlot);
        this.removeStack(parentSlot);
    }

    public void markDirty() {
        for (int i = 0; i < this.totalAmounts.length; ++i) {
            int totalAmount = this.worthToUnits(this.totalAmounts[i], i);
            int inputSlot = this.getInputSlot(i);
            int outputSlot = this.getOutputSlot(i);
            int inputCount = ((ItemStack)this.stacks.get(inputSlot)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(inputSlot)).func_190916_E();
            int remaining = this.worthToUnits(this.getParentSlotLimit(i) - this.totalAmounts[i], i);
            int outputCount = ((ItemStack)this.stacks.get(outputSlot)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(outputSlot)).func_190916_E();
            ItemStack parentSlotStack = this.getParentSlotStack(i);
            if (inputCount != Math.max(parentSlotStack.func_77976_d() - remaining, 0)) {
                int n = i;
                this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth(inputCount - Math.max(parentSlotStack.func_77976_d() - remaining, 0), i);
            }
            if (outputCount != Math.min(totalAmount, parentSlotStack.func_77976_d())) {
                int n = i;
                this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth(outputCount - Math.min(totalAmount, parentSlotStack.func_77976_d()), i);
            }
            this.updateInputOutputSlots(i);
            if (!this.getParentSlotRemovable(i) || this.totalAmounts[i] != 0) continue;
            this.removeValidItemStackFromSlot(i);
        }
    }

    protected int getParentSlotLimit(int parentSlot) {
        return this.totalLimits[parentSlot];
    }

    private int worthToUnits(int worth, int parentSlot) {
        return worth / this.getParentSlotUnitWorth(parentSlot);
    }

    protected int getParentSlotUnitWorth(int parentSlot) {
        return this.unitWorth[parentSlot];
    }

    protected boolean getParentSlotRemovable(int parentSlot) {
        return false;
    }

    private int unitsToWorth(int units, int parentSlot) {
        return units * this.getParentSlotUnitWorth(parentSlot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(slot)), (ItemStack)stack) || !stack.func_190926_b() && (!this.isItemStackValidForParentSlot(stack, this.getParentSlot(slot)) || this.alreadyExistsInAnotherSlot(stack, this.getParentSlot(slot)))) {
            return;
        }
        int parentSlot = this.getParentSlot(slot);
        if (!stack.func_190926_b() && parentSlot == this.filterStacks.size()) {
            this.addValidItemStack(stack);
        }
        int n = parentSlot;
        this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth((stack.func_190926_b() ? 0 : stack.func_190916_E()) - (((ItemStack)this.stacks.get(slot)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(slot)).func_190916_E()), parentSlot);
        if (this.totalAmounts[parentSlot] == 0) {
            this.removeValidItemStackFromSlot(parentSlot);
        } else {
            if (!this.isInputSlot(slot)) {
                this.stacks.set(slot, (Object)stack);
            }
            this.updateInputOutputSlots(parentSlot);
        }
    }

    private boolean alreadyExistsInAnotherSlot(ItemStack stack, int parentSlot) {
        for (int i = 0; i < this.filterStacks.size(); ++i) {
            if (i == parentSlot || !ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.stacks.get(this.getOutputSlot(i))), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    private void updateInputOutputSlots(int parentSlot) {
        int inputAmount;
        ItemStack outputStack;
        ItemStack parentSlotStack = this.getParentSlotStack(parentSlot);
        if (parentSlotStack.func_190926_b()) {
            return;
        }
        int outputSlot = this.getOutputSlot(parentSlot);
        int inputSlot = this.getInputSlot(parentSlot);
        if (((ItemStack)this.stacks.get(outputSlot)).func_190926_b()) {
            this.stacks.set(outputSlot, (Object)parentSlotStack.func_77946_l());
        }
        if ((outputStack = (ItemStack)this.stacks.get(outputSlot)).func_190916_E() < parentSlotStack.func_77976_d() && outputStack.func_190916_E() < this.worthToUnits(this.totalAmounts[parentSlot], parentSlot) || outputStack.func_190916_E() > this.worthToUnits(this.totalAmounts[parentSlot], parentSlot)) {
            outputStack.func_190920_e(Math.min(parentSlotStack.func_77976_d(), this.worthToUnits(this.totalAmounts[parentSlot], parentSlot)));
        }
        int remainingCapacity = this.worthToUnits(this.getParentSlotLimit(parentSlot) - this.totalAmounts[parentSlot], parentSlot);
        int n = inputAmount = ((ItemStack)this.stacks.get(inputSlot)).func_190926_b() ? 0 : ((ItemStack)this.stacks.get(inputSlot)).func_190916_E();
        if (inputAmount != Math.max(parentSlotStack.func_77976_d() - remainingCapacity, 0)) {
            this.stacks.set(inputSlot, (Object)parentSlotStack.func_77946_l());
            ((ItemStack)this.stacks.get(inputSlot)).func_190920_e(Math.max(parentSlotStack.func_77976_d() - remainingCapacity, 0));
        }
        if (!((ItemStack)this.stacks.get(inputSlot)).func_190926_b() && ((ItemStack)this.stacks.get(inputSlot)).func_190916_E() == 0) {
            this.stacks.set(inputSlot, (Object)ItemStack.field_190927_a);
        }
    }

    private ItemStack getParentSlotStack(int parentSlot) {
        return (ItemStack)this.filterStacks.get(parentSlot);
    }

    public void setParentSlotStack(int parentSlot, ItemStack filterStack) {
        this.filterStacks.set(parentSlot, (Object)filterStack.func_77946_l());
    }

    protected boolean isItemStackValidForParentSlot(ItemStack stack, int parentSlot) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((ItemStack)this.filterStacks.get(parentSlot)));
    }

    private int getInputSlot(int parentSlot) {
        return parentSlot * 2;
    }

    private int getOutputSlot(int parentSlot) {
        return parentSlot * 2 + 1;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        int remainingTotal;
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        int parentSlot = this.getParentSlot(slot);
        if (!this.isItemStackValidForParentSlot(stack, parentSlot) || this.alreadyExistsInAnotherSlot(stack, parentSlot)) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(parentSlot >= this.filterStacks.size() ? stack : (ItemStack)this.filterStacks.get(parentSlot));
        if (!existing.func_190926_b()) {
            limit -= existing.func_190916_E();
        }
        if ((limit = Math.min(limit, remainingTotal = this.worthToUnits(this.getParentSlotLimit(parentSlot) - (parentSlot >= this.totalAmounts.length ? 0 : this.totalAmounts[parentSlot]), parentSlot))) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (parentSlot == this.filterStacks.size()) {
                this.addValidItemStack(stack);
            }
            int n = parentSlot;
            this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth(reachedLimit ? limit : stack.func_190916_E(), parentSlot);
            if (!this.isInputSlot(slot)) {
                if (existing.func_190926_b()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                }
            }
            this.updateInputOutputSlots(parentSlot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getStackInParentSlot(int parentSlot) {
        if (parentSlot >= this.filterStacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.filterStacks.get(parentSlot);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        if (((ItemStack)this.stacks.get(slot)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int numberRemoved = Math.min(existing.func_190916_E(), amount);
        if (!simulate) {
            int n = this.getParentSlot(slot);
            this.totalAmounts[n] = this.totalAmounts[n] - numberRemoved;
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - numberRemoved)));
            if (this.totalAmounts[this.getParentSlot(slot)] == 0 && this.dynamicSize) {
                this.removeValidItemStackFromSlot(this.getParentSlot(slot));
            } else {
                this.updateInputOutputSlots(this.getParentSlot(slot));
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)numberRemoved);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        NBTTagList nbtAmountsList = new NBTTagList();
        for (int totalAmount : this.totalAmounts) {
            NBTTagInt amountTag = new NBTTagInt(totalAmount);
            nbtAmountsList.func_74742_a((NBTBase)amountTag);
        }
        nbt.func_74782_a("TotalAmounts", (NBTBase)nbtAmountsList);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int stacksSize = nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size();
        this.setSize(stacksSize);
        NBTTagList amounts = nbt.func_150295_c("TotalAmounts", 3);
        this.setFilterStacksSize(amounts.func_74745_c());
        for (int i = 0; i < amounts.func_74745_c(); ++i) {
            this.totalAmounts[i] = ((NBTTagInt)amounts.func_179238_g(i)).func_150287_d();
        }
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)new ItemStack(itemTags));
            if (this.filterStacks.size() <= this.getParentSlot(slot)) continue;
            ItemStack filterStack = ((ItemStack)this.stacks.get(slot)).func_77946_l();
            filterStack.func_190920_e(1);
            this.filterStacks.set(this.getParentSlot(slot), (Object)filterStack);
        }
    }

    void setDynamicSize(boolean dynamicSize) {
        if (this.dynamicSize != dynamicSize) {
            this.dynamicSize = dynamicSize;
            if (this.dynamicSize) {
                this.expandStacks();
            } else {
                this.removeStack(this.filterStacks.size());
            }
        }
    }

    NonNullList<ItemStack> getFilterStacks() {
        return this.filterStacks;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    private int getStackLimit(ItemStack stack) {
        return stack.func_77976_d();
    }

    private void setSize(int size) {
        if (this.stacks.size() != size) {
            this.stacks = FilteredItemStackHandler.getDefaultSizedList(size);
        }
    }

    private static NonNullList<ItemStack> getDefaultSizedList(int size) {
        return FilteredItemStackHandler.addEmptyStacks((NonNullList<ItemStack>)NonNullList.func_191196_a(), size);
    }

    private static NonNullList<ItemStack> addEmptyStacks(NonNullList<ItemStack> list, int count) {
        for (int i = 0; i < count; ++i) {
            list.add((Object)ItemStack.field_190927_a);
        }
        return list;
    }

    private void setFilterStacksSize(int size) {
        if (this.filterStacks.size() != size) {
            this.filterStacks = FilteredItemStackHandler.getDefaultSizedList(size);
            this.totalAmounts = new int[size];
        }
    }
}

